/**
 * Factory responsible for all employee related operations
 */

(function() {
	app.factory('employeeServices', [
			"urlServices",
			"$q",
			"Restangular",
			"Utils",
			"$location",
			"holidayService",
			function(urlServices, $q, Restangular, Utils, $location, holidayService) {

				var URL = "";
				var environment = "";
				var levelFlag = "";
				var empName = null;
				var prodcertName = "";
				var managerName = "";
				var locationId = "";
				var locationName = "";
				var holiday = [];
				var locationList = [];

				var workState = "";
				var overtimeStatus = "";
				var authorizedFlag = false;
				var status = {};

				var extraWeeksToSubmit = false;
				var needHistoryView = false;
				var timesheets = [];
				var reportsURL = "";
				function setEnvironment(envType) {
					environment = envType;
					URL = (environment === "dev") ? urlServices.returnDevUrl() : urlServices.returnProdUrl();
				}

				function getEnvironment() {
					return environment;
				}

				function getUrlObj() {
					return URL;
				}

				function getEmpData() {

					var flag = false; //for the getHistory if is excecuted
					var deferred = $q.defer();
					if (empName === null) {
						extraWeeksToSubmit = false;
						needHistoryView = false;
						timesheets = [];
						Restangular.all(URL.mainPageDetails).getList().then(function(resp) {
							if (resp) {
								if (Utils.isValidResponse(resp)) {
									if (resp[0]) {
										holiday = resp[0].Holidays;
										locationList = resp[0].LocationsList;
										if (resp[0].data) {
											if (resp[0].data[0]) {
												setEmployeeDetails(resp[0].data[0]);
												reportsURL = resp[0].reportURL;
												if (authorizedFlag === false) {
													if (status) {
														if (status.weeks) {
															if (status.weeks.length !== 0) {
																extraWeeksToSubmit = true;
															}
														}
													}
													if (extraWeeksToSubmit === false) {
														flag = true;
														//getHistoryData
														var yearList = holidayService.getYearList();
														var data = {
															"alias" : prodcertName,
															"startdate" : Utils.respDateFormat("01/01/" + yearList[0],
																	true),
															"enddate" : Utils.respDateFormat("12/31/" +
																	yearList[yearList.length - 1], true)
														};
														getHistory(data, false).then(function(resp) {
															if (resp) {
																if (resp.length !== 0) {
																	needHistoryView = true;
																	timesheets = resp;
																}
															}
															deferred.resolve(sentResponse());
														}, function(resp) {
															if (!resp) {
																resp = {};
															}
															resp.printError = true;
															deferred.reject(resp);
														});
													}
												}
											}
										}
									}
									if (flag === false) {
										deferred.resolve(sentResponse());
									}
								} else {
									deferred.reject(resp);
								}
							} else {
								resp = {};
								resp.printError = true;
								deferred.reject(resp);
							}
						},
								function(resp) {
									if (!resp) {
										resp = {};
									}
									resp.printError = true;
									deferred.reject(resp);
								});
					} else {
						deferred.resolve(sentResponse());
					}
					return deferred.promise;
				}

				function getHistory(data, reload) {
					var deferred = $q.defer();
					var url = getUrlObj().getTimesheetsHistory;

					if (timesheets.length === 0 || reload === true) {
						Restangular.all(url).post(data, "get").then(function(response) {
							if (response) {
								if (response.success === false) {
									response.printError = true;
									deferred.reject(response);
								} else {
									//timesheet saved to variable, if historyOnlyView
									deferred.resolve(response.data);
								}
							} else {
								response = {};
								response.printError = true;
								deferred.reject(response);
							}
						}, function(response) {
							if (!response) {
								response = {};
							}
							response.printError = true;
							deferred.reject(response);
						});
					} else {
						deferred.resolve(timesheets);
					}
					return deferred.promise;
				}

				function sentResponse() {
					return ({
						empName : empName,
						levelFlag : levelFlag,
						authorizedFlag : authorizedFlag,
						extraWeeksToSubmit : extraWeeksToSubmit,
						needHistoryView : needHistoryView,
						reportsURL : reportsURL
					});
				}

				function setEmployeeDetails(employeeDetails) {

					levelFlag = employeeDetails.sRole.toLowerCase();
					empName = employeeDetails.sEmpName;
					prodcertName = employeeDetails.ProdcertName;
					managerName = employeeDetails.Manager;
					locationId = employeeDetails.nLocationID;
					locationName = employeeDetails.locationName;

					authorizedFlag = employeeDetails.isAuthorized;
					overtimeStatus = employeeDetails.overtimeStatus;
					workState = employeeDetails.workState;
					status = employeeDetails.status;
					holidayService.setYearList();
					holidayService.setRegionSortedHolidays(holiday, locationList);

				}

				function getLevelFlag() {
					return levelFlag;
				}

				function getEmpName() {
					return empName;
				}

				function getProdcertName() {
					return prodcertName;
				}

				function getLocationsList() {
					return locationList;
				}

				function getLocationName(id) {
					if (!id) {
						id = locationId;
					}
					for (var i = 0; i < locationList.length; i += 1) {

						if (locationList[i].nLocationID === id) {
							locationName = locationList[i].sRegionName;
							break;
						}
					}
					return locationName;

				}
				function getLocationId() {
					return locationId;
				}

				function getStatusChangedDetails() {
					return status;
				}

				function getStatusDetails() {
					return {
						"status" : status,
						"overtimeStatus" : overtimeStatus,
						"workState" : workState,
						"isAuthorized" : authorizedFlag
					};
				}

				return {
					"setEnvironment" : setEnvironment,
					"getEnvironment" : getEnvironment,
					"getUrlObj" : getUrlObj,
					"getEmpData" : getEmpData,
					"getLevelFlag" : getLevelFlag,
					"getEmpName" : getEmpName,
					"getProdcertName" : getProdcertName,
					"getLocationId" : getLocationId,
					"getLocationsList" : getLocationsList,
					"getLocationName" : getLocationName,
					"getStatusChangedDetails" : getStatusChangedDetails,
					"getStatusDetails" : getStatusDetails,
					"sentResponse" : sentResponse,
					"getHistory" : getHistory
				};
			} ]);
})();