/**
 * Factory responsible for timesheet time calculation related operations
 */
(function() {
	'use strict';
	app
			.factory('timeCalculationServices',
					[
							"i8nConstants",
							"TIMESHEET_CONSTANTS",
							function(i8nConstants, TIMESHEET_CONSTANTS) {

								function updateTimesheetTime(pos, timesheet, statusDetails) {
									timesheet.disableSubmitUntilSaved = true;
									var totalTime = "";

									if (parseInt(timesheet.data[pos].startHour) === 12) {
										if (timesheet.data[pos].startDayHalf === "AM") {
											timesheet.data[pos].startTime = 0;
										} else {
											timesheet.data[pos].startTime = 12 * 60;
										}
									} else {
										if (timesheet.data[pos].startDayHalf === "PM") {
											timesheet.data[pos].startTime = (parseInt(timesheet.data[pos].startHour) + 12) * 60;
											if (parseInt(timesheet.data[pos].startHour) === 0) {
												//timesheet.data[pos].startHour = "12";
												timesheet.data[pos].startTime = 0;
											}
										} else {
											timesheet.data[pos].startTime = parseInt(timesheet.data[pos].startHour) * 60;
										}
									}

									if (parseInt(timesheet.data[pos].endHour) === 12) {
										if (timesheet.data[pos].endDayHalf === "AM") {
											timesheet.data[pos].endTime = 0;
										} else {
											timesheet.data[pos].endTime = 12 * 60;
										}
									} else {
										if (timesheet.data[pos].endDayHalf === "PM") {
											timesheet.data[pos].endTime = (parseInt(timesheet.data[pos].endHour) + 12) * 60;
											if (parseInt(timesheet.data[pos].endHour) === 0) {
												//timesheet.data[pos].endHour = "12";
												timesheet.data[pos].endTime = 0;
											}
										} else {
											timesheet.data[pos].endTime = parseInt(timesheet.data[pos].endHour) * 60;
										}
									}

									timesheet.data[pos].endTime = timesheet.data[pos].endTime +
											parseInt(timesheet.data[pos].endMinute);
									timesheet.data[pos].startTime = timesheet.data[pos].startTime +
											parseInt(timesheet.data[pos].startMinute);

									totalTime = timesheet.data[pos].endTime - timesheet.data[pos].startTime;
									var brakeTime = parseInt(timesheet.data[pos].breakTime) > 15 ? parseInt(timesheet.data[pos].breakTime)
											: 0;
									timesheet.data[pos].NoOfHours = parseFloat(((totalTime - brakeTime) / 60)
											.toFixed(2));
									timesheet.data[pos].invalidTime = false;
									if (timesheet.data[pos].NoOfHours < 0 ||
											(timesheet.data[pos].NoOfHours === 0 && timesheet.data[pos].startTime !== 0 && timesheet.data[pos].endTime !== 0)) {
										timesheet.data[pos].invalidTime = true;
										timesheet.data[pos].startTime = 0;
										timesheet.data[pos].endTime = 0;
										timesheet.data[pos].NoOfHours = 0;
									}

									updateSummary(timesheet, statusDetails);
								}

								function updateSummary(timesheet, statusDetails) {

									timesheet.regularHours = 0;
									timesheet.overtimeHours = 0;
									timesheet.doubleOvertimeHours = 0;
									timesheet.totalHours = 0;

									for (var i = 0; i < timesheet.data.length; i += 1) {
										var empPayType = statusDetails.overtimeStatus;
										var locationType = statusDetails.workState;

										//handle location and status change
										if (statusDetails.status) {
											if (statusDetails.status.dateOfChange) {
												statusDetails.status.dateOfChange = new Date(
														statusDetails.status.dateOfChange).setHours(0, 0, 0, 0);
												if (new Date(timesheet.data[i].date).getTime() < new Date(
														statusDetails.status.dateOfChange).getTime()) {
													locationType = statusDetails.status.prevWorkState;
													empPayType = statusDetails.status.prevOvertimeStatus;
												}
											}
										}

										// calculate the hours
										if (empPayType === TIMESHEET_CONSTANTS.REGULAR) {
											if (locationType === TIMESHEET_CONSTANTS.TYPE_CA) {
												CARegular(timesheet, i);
											} else if (locationType === TIMESHEET_CONSTANTS.TYPE_NORMAL) {
												NRRegular(timesheet, i);
											}
										} else if (empPayType === TIMESHEET_CONSTANTS.OVETTIME) {
											if (locationType === TIMESHEET_CONSTANTS.TYPE_CA) {
												CAOvertime(timesheet, i);
											} else if (locationType === TIMESHEET_CONSTANTS.TYPE_NORMAL) {
												NROvertime(timesheet, i);
											}
										} else if (empPayType === TIMESHEET_CONSTANTS.DEV) {
											development(timesheet, i);
										}

									}

									//restrict max regular hours
									if (timesheet.regularHours > TIMESHEET_CONSTANTS.MAX_REGULAR_HOURS * 60) {
										timesheet.overtimeHours = timesheet.overtimeHours +
												(timesheet.regularHours - TIMESHEET_CONSTANTS.MAX_REGULAR_HOURS * 60);
										timesheet.regularHours = TIMESHEET_CONSTANTS.MAX_REGULAR_HOURS * 60;
									}

									//All data in minutes, convert to hrs
									timesheet.regularHours = parseFloat(((timesheet.regularHours) / 60.00).toFixed(2));
									timesheet.overtimeHours = parseFloat(((timesheet.overtimeHours) / 60.00).toFixed(2));
									timesheet.doubleOvertimeHours = parseFloat(((timesheet.doubleOvertimeHours) / 60.00)
											.toFixed(2));
									timesheet.totalHours = timesheet.regularHours + timesheet.overtimeHours +
											timesheet.doubleOvertimeHours;

								}

								function CARegular(timesheet, pos) {
									timesheet.regularHours = (timesheet.regularHours) +
											((timesheet.data[pos].NoOfHours) > TIMESHEET_CONSTANTS.REGULAR_WORKING_HOURS ? TIMESHEET_CONSTANTS.REGULAR_WORKING_HOURS * 60
													: (timesheet.data[pos].NoOfHours) * 60);
									timesheet.overtimeHours = (timesheet.overtimeHours) +
											((timesheet.data[pos].NoOfHours - TIMESHEET_CONSTANTS.REGULAR_WORKING_HOURS) > TIMESHEET_CONSTANTS.OVERTIME_WORKING_HOURS ? TIMESHEET_CONSTANTS.OVERTIME_WORKING_HOURS * 60
													: ((timesheet.data[pos].NoOfHours - TIMESHEET_CONSTANTS.REGULAR_WORKING_HOURS) > 0 ? (timesheet.data[pos].NoOfHours - TIMESHEET_CONSTANTS.REGULAR_WORKING_HOURS) * 60
															: 0));
									timesheet.doubleOvertimeHours = (timesheet.doubleOvertimeHours) +
											((timesheet.data[pos].NoOfHours - (TIMESHEET_CONSTANTS.REGULAR_WORKING_HOURS + TIMESHEET_CONSTANTS.OVERTIME_WORKING_HOURS)) > 0 ? (timesheet.data[pos].NoOfHours - (TIMESHEET_CONSTANTS.REGULAR_WORKING_HOURS + TIMESHEET_CONSTANTS.OVERTIME_WORKING_HOURS)) * 60
													: 0);
								}

								function CAOvertime(timesheet, pos) {
									timesheet.overtimeHours = (timesheet.overtimeHours) +
											((timesheet.data[pos].NoOfHours) > TIMESHEET_CONSTANTS.OVERTIME_WORKING_HOURS ? TIMESHEET_CONSTANTS.OVERTIME_WORKING_HOURS * 60
													: (timesheet.data[pos].NoOfHours) * 60);
									timesheet.doubleOvertimeHours = (timesheet.doubleOvertimeHours) +
											((timesheet.data[pos].NoOfHours - TIMESHEET_CONSTANTS.OVERTIME_WORKING_HOURS) > 0 ? (timesheet.data[pos].NoOfHours - TIMESHEET_CONSTANTS.OVERTIME_WORKING_HOURS) * 60
													: 0);
								}

								function NRRegular(timesheet, pos) {
									timesheet.regularHours = timesheet.regularHours +
											((timesheet.data[pos].NoOfHours) * 60);

								}
								function NROvertime(timesheet, pos) {
									timesheet.overtimeHours = (timesheet.overtimeHours) +
											timesheet.data[pos].NoOfHours * 60;
								}

								function development(timesheet, pos) {
									timesheet.regularHours = (timesheet.regularHours) +
											((timesheet.data[pos].NoOfHours) > TIMESHEET_CONSTANTS.REGULAR_WORKING_HOURS ? TIMESHEET_CONSTANTS.REGULAR_WORKING_HOURS * 60
													: (timesheet.data[pos].NoOfHours) * 60);

									//timesheet.regularHours = timesheet.regularHours +	((timesheet.data[pos].NoOfHours) * 60);
								}

								return {
									"updateTimesheetTime" : updateTimesheetTime
								};
							} ]);
})();